/************************************************************************
* Rutoken                                                               *
* Copyright (C) Aktiv Co. 2003 - 2014                                   *
*  :  http://www.rutoken.ru                          *
*  :    http://www.rutoken.ru/hotline/download/drivers/*
*  : http://www.rutoken.ru/hotline/                 *
*-----------------------------------------------------------------------*
*               *
*     Rutoken    Cert2Cont:          * 
*  -     ;                       * 
*  -     ;                         *
*  -            *
*    .                                                     *
************************************************************************/
    

#include "stdafx.h"
#include "Containers.h"
#include "Cert2Cont.h"
#include "Util_Funcs.h"
#include <atlbase.h>
#include <atlconv.h>


/************************************************************************
*   ,                     *
************************************************************************/
bool EnumContainers( IN   LPTSTR lpszCSPs[],
                     IN   DWORD  pdwCSPTypes[],
                     IN   DWORD  dwSelectedCSP,
                     OUT  BYTE*  pbtContainers[],
                     OUT  DWORD& dwContainersCount )
{
    bool        bResult          = true;          //       
     
    HCRYPTPROV  hCryptProv       = NULL;          //  

    BYTE*       pbtCurCont       = NULL;          //        
    DWORD       dwCurContNameLen = 0;             //       
    DWORD       dwIndex          = 0;             //  
    bool        bIsContNotNeeded = true;          //  true,     

    DWORD       dwError          = ERROR_SUCCESS; //      
    
    dwContainersCount = 0;


    /************************************************************************
    *      ATL    *
    *   ANSI  UNICODE                                       * 
    ************************************************************************/
    USES_CONVERSION;    


    /************************************************************************
    *                                          *
    ************************************************************************/
    bResult = (    CryptAcquireContext( &hCryptProv,
                                        NULL,
                                        lpszCSPs[dwSelectedCSP],
                                        pdwCSPTypes[dwSelectedCSP],
                                        CRYPT_VERIFYCONTEXT )
                != FALSE );
    if (!bResult)
    {
        dwError = GetLastError();
        PrintErrorText(TEXT("CryptAcquireContext"),
                       dwError );
        return bResult;
    }

    for (   dwIndex = 0;
            dwIndex < C2C_MAX_ENUM_COUNT;
            dwIndex++ )
    {
        /************************************************************************
        *                          *
        * (   )                                        * 
        ************************************************************************/
        pbtCurCont = (BYTE*)LocalAlloc( LMEM_ZEROINIT,
                                        MAX_PATH);
        dwCurContNameLen = MAX_PATH;

        bResult = (    CryptGetProvParam( hCryptProv,
                                          PP_ENUMCONTAINERS,
                                          pbtCurCont,
                                          &dwCurContNameLen,
                                          ((dwIndex == 0 ) ? CRYPT_FIRST : 0) )
                    != FALSE );
        if (!bResult)
        {
            dwError = GetLastError();
            if (dwError == ERROR_NO_MORE_ITEMS)
            {
                bResult = true;
                LocalFree(pbtCurCont);
                break;
            }
            else
            {
                LocalFree(pbtCurCont);
                PrintErrorText(TEXT("CryptGetProvParam"),
                               dwError );
                break;
            }
        }

        /************************************************************************
        *                                 *
        ************************************************************************/
        bResult = CheckCertificateInContainer(  lpszCSPs[dwSelectedCSP],
                                                pdwCSPTypes[dwSelectedCSP],
                                                A2T((LPSTR)pbtCurCont),
                                                bIsContNotNeeded );
        if (!bResult)
        {
            LocalFree(pbtCurCont);
            break;
        }

        if (bIsContNotNeeded)
        {
            LocalFree(pbtCurCont);
            continue;
        }
        else
        {
            /************************************************************************
            *                    *
            ************************************************************************/
            dwContainersCount++;
            pbtContainers[dwContainersCount - 1] = pbtCurCont;
            pbtCurCont = NULL;
        }
    }

    /************************************************************************
    *                                        *
    ************************************************************************/
    bResult = (   CryptReleaseContext( hCryptProv,
                                       0)
               != FALSE);
    if (!bResult)
    {
        dwError = GetLastError();
        PrintErrorText(    TEXT("CryptReleaseContext"),
                            dwError );
    }

    bResult = (dwContainersCount > 0 );
    if (!bResult)
        _tprintf(TEXT("Error: there are no aviable containers in CSP,\n\tor no containers without certificate.\n"));

    return bResult;
}

/************************************************************************
*                                 *
************************************************************************/
bool CheckCertificateInContainer( IN  LPCTSTR lpszCSP,
                                  IN  DWORD   dwCryptProvType,
                                  IN  LPCTSTR lpszContainer,
                                  OUT bool&   bCertificateExists )
{
    bool        bResult          = true;          //       
    HCRYPTPROV  hCryptProv       = NULL;          //  
    DWORD       dwError          = ERROR_SUCCESS; //      


    /************************************************************************
    *                                          *
    ************************************************************************/
    bResult = (    CryptAcquireContext( &hCryptProv,
                                        lpszContainer,
                                        lpszCSP,
                                        dwCryptProvType,
                                        0 )
                != FALSE );
    if (!bResult)
    {
        dwError = GetLastError();
        CryptReleaseContext(hCryptProv,
                            0);
        PrintErrorText(TEXT("CryptAcquireContext"),
                       dwError );
        return bResult;
    }

    /************************************************************************
    *       AT_KEYEXCHANGE                *
    ************************************************************************/
    bResult = CheckKeyCertificate(  hCryptProv,
                                    AT_KEYEXCHANGE,
                                    bCertificateExists );
    if (    !bResult
        ||    bCertificateExists )
    {
        CryptReleaseContext(hCryptProv, 0);
        return bResult;
    }

    /************************************************************************
    *       AT_SIGNATURE                  *
    ************************************************************************/
    bResult = CheckKeyCertificate(  hCryptProv,
                                    AT_SIGNATURE,
                                    bCertificateExists );

    /************************************************************************
    *                                        *
    ************************************************************************/
    CryptReleaseContext(hCryptProv,
                        0);
    return bResult;
}

/************************************************************************
*                            *
*                                            *
************************************************************************/
bool CheckKeyCertificate( IN  HCRYPTPROV hCryptProv,
                          IN  DWORD      dwKeySpec,
                          OUT bool&      bCertificateExists)
{
    bool        bResult          = true;          //       
    HCRYPTKEY   hCryptKey        = NULL;          //   
    
    DWORD       dwError          = ERROR_SUCCESS; //      
    
    DWORD       dwCertBufferLen  = 0;             //        

    bCertificateExists = false;

    /************************************************************************
    *                                              *
    ************************************************************************/
    bResult = (    CryptGetUserKey(hCryptProv,
                                   dwKeySpec,
                                   &hCryptKey )
                != FALSE );

    dwError = GetLastError();

    bResult = (    bResult
                || dwError == NTE_NO_KEY);

    if (!bResult)
    {
        PrintErrorText(TEXT("CryptGetUserKey"),
                       dwError);
        return bResult;
    }

    if (dwError == NTE_NO_KEY)
        return bResult;
    

    /************************************************************************
    *                       *
    ************************************************************************/
    bResult = (    CryptGetKeyParam(hCryptKey,
                                    KP_CERTIFICATE,
                                    NULL,
                                    &dwCertBufferLen,
                                    0)
                != FALSE );

    /************************************************************************
    *                                            *
    ************************************************************************/
    dwError = GetLastError();
    CryptDestroyKey(hCryptKey);
    hCryptKey = NULL;
    
    if (!bResult)
    {
        if (dwError == SCARD_E_NO_SUCH_CERTIFICATE)
        {
            bResult = true;
            return bResult;
        }

        PrintErrorText(TEXT("CryptGetKeyParam"),
                       dwError );
        return bResult;
    }
    
    bCertificateExists = true;
    return bResult;
}


/************************************************************************
*        ,        * 
*                      * 
* ,                                    *
************************************************************************/
DWORD SelectContainer( IN LPCTSTR lpszPreferredContainer,
                       IN BYTE*   pbtContainers[],
                       IN DWORD   dwContainersCount )
{
    DWORD dwSelectedContainer  = C2C_BAD_SELECT;  //  .     
    DWORD dwIndex              = 0;               //  


    /************************************************************************
    *      ATL    *
    *   ANSI  UNICODE                                       * 
    ************************************************************************/
    USES_CONVERSION;


    if (lpszPreferredContainer)
    {
        /************************************************************************
        *        , *
        *  :                                                   *
        *  -   ,  ,         *
        *    ,    ;                       * 
        *  -    ,   ,        *
        *     .                                              *
        ************************************************************************/
        for (   dwIndex = 0;
                dwIndex < dwContainersCount;
                dwIndex++ )
        {
            if (::memcmp(lpszPreferredContainer,
                         A2T((LPSTR)pbtContainers[dwIndex]),
                         ((_tcsclen(lpszPreferredContainer) + 1)*sizeof(TCHAR)) )
                == 0)
            {
                dwSelectedContainer = dwIndex;
                break;
            }
        }
    }
    else
    {    
        /************************************************************************
        *         ,       *
        *   :                                         *
        *  -     ;               *
        *  -     ,            * 
        *      .                                   *
        ************************************************************************/
        _tprintf(TEXT("\nSelect container:\n"));
        for (   dwIndex = 0;
                dwIndex < dwContainersCount;
                dwIndex++ )
            _tprintf(TEXT("[%d] - %s\n"), dwIndex, A2T((LPSTR)pbtContainers[dwIndex]));

        if (    (_tscanf(TEXT("%d"), &dwSelectedContainer) != 1)
            ||  ((dwSelectedContainer + 1) > dwContainersCount) )
        {
            _tprintf(TEXT("Input error.\n"));
            dwSelectedContainer = C2C_BAD_SELECT;
            return dwSelectedContainer;
        }
    }

    if (dwSelectedContainer == C2C_BAD_SELECT)
        _tprintf(TEXT("Error: no such container in CSP, or \n\tcertificate is in container already.\n"));
    else
        _tprintf(TEXT("Selected container: \"%s\".\n"), A2T((LPSTR)pbtContainers[dwSelectedContainer]));

    return dwSelectedContainer;
}
