/************************************************************************
* Rutoken                                                               *
* Copyright (C) Aktiv Co. 2003 - 2014                                   *
*  :  http://www.rutoken.ru                          *
*  :    http://www.rutoken.ru/hotline/download/drivers/*
*  : http://www.rutoken.ru/hotline/                 *
*-----------------------------------------------------------------------*
*             *
*     Rutoken    Cert2Cont.        *
************************************************************************/

    
#include "stdafx.h"
#include "Import.h"
#include "Keys.h"
#include "Util_Funcs.h"
#include <atlbase.h>
#include <atlconv.h>


/************************************************************************
*                                      *
************************************************************************/
bool ImportCertificateToContainer( IN LPTSTR lpszCSPs[],
                                   IN DWORD  pdwCSPTypes[],
                                   IN DWORD  dwSelectedCSP,
                                   IN BYTE*  pbtContainers[],
                                   IN DWORD  dwSelectedContainer,
                                   IN DWORD  dwPreferredKeySpec,
                                   IN LPVOID lpvCertBuffer,
                                   IN DWORD  dwCertBufferSize )
{
    bool                  bResult             = true;          //       

    HCRYPTPROV            hCryptProv          = NULL;          //  
    HCRYPTKEY             hCryptKey           = NULL;          //   
    DWORD                 dwKeySpec           = 0;

    DWORD                 dwError             = ERROR_SUCCESS; //      
    
    PCCERT_CONTEXT        pCertContext        = NULL;          //      CERT_CONTEXT

    PCERT_PUBLIC_KEY_INFO pContPubKeyInfo     = NULL;          //      CERT_PUBLIC_KEY_INFO
    DWORD                 dwContPubKeyInfoLen = 0;             //    
        
    /************************************************************************
    *      ATL    *
    *   ANSI  UNICODE                                       * 
    ************************************************************************/
    USES_CONVERSION;


    /************************************************************************
    *                                          *
    ************************************************************************/
    bResult = (    CryptAcquireContext(&hCryptProv,
                                       A2T((LPCSTR)(pbtContainers[dwSelectedContainer])),
                                       lpszCSPs[dwSelectedCSP],
                                       pdwCSPTypes[dwSelectedCSP],
                                       0)
                != FALSE );

    if (!bResult)
    {
        dwError = GetLastError();
        PrintErrorText(TEXT("CryptAcquireContext"),
                       dwError );
        return 0;
    }
    
    /************************************************************************
    *                   *
    ************************************************************************/
    bResult = GetCryptKey(  hCryptProv,
                            dwPreferredKeySpec,
                            hCryptKey,
                            dwKeySpec );
    if (!bResult)
    {
        CryptReleaseContext(hCryptProv, 0);
        return bResult;
    }

    /************************************************************************
    *               *
    ************************************************************************/
    bResult = GetPublicKeyBlobFromCryptProv(    hCryptProv,
                                                dwKeySpec,
                                                pContPubKeyInfo,
                                                dwContPubKeyInfoLen );
    if (!bResult)
    {
        CryptDestroyKey(hCryptKey);
        CryptReleaseContext(hCryptProv, 0);
        return bResult;
    }

    /************************************************************************
    *              *
    ************************************************************************/
    pCertContext = CertCreateCertificateContext((X509_ASN_ENCODING | PKCS_7_ASN_ENCODING),
                                                (const BYTE*) lpvCertBuffer,
                                                dwCertBufferSize );
    bResult = (pCertContext != NULL);
    if (!bResult)
    {
        FreeBuffer((LPVOID*)&pContPubKeyInfo);

        CryptDestroyKey(hCryptKey);
        CryptReleaseContext(hCryptProv, 0);
        return bResult;
    }


    /************************************************************************
    *                                                  *
    ************************************************************************/
    bResult = (CertComparePublicKeyInfo((X509_ASN_ENCODING | PKCS_7_ASN_ENCODING),
                                        pContPubKeyInfo,
                                        &(pCertContext->pCertInfo->SubjectPublicKeyInfo) )
                != FALSE );
    if (!bResult)
    {
        FreeBuffer((LPVOID*)&pContPubKeyInfo);

        CertFreeCertificateContext(pCertContext);

        bResult = false;
        _tprintf(TEXT("Error: certificate doesn't correspond with public key in container.\n"));
        return bResult;
    }

    /************************************************************************
    *                                      *
    ************************************************************************/
    bResult = (    CryptSetKeyParam(hCryptKey,
                                    KP_CERTIFICATE,
                                    (const BYTE*)lpvCertBuffer,
                                    0)
                != FALSE );

    dwError = GetLastError();
	
    /************************************************************************
    *  ,                           *
    *  PCERT_PUBLIC_KEY_INFO                                       *
    ************************************************************************/
    FreeBuffer((LPVOID*)&pContPubKeyInfo);

    /************************************************************************
    *  ,                           *
    *  CERT_CONTEXT                                                *
    ************************************************************************/
    CertFreeCertificateContext(pCertContext);

    /************************************************************************
    *                                            *
    ************************************************************************/
    CryptDestroyKey(hCryptKey);

    /************************************************************************
    *                                        *
    ************************************************************************/
    CryptReleaseContext(hCryptProv, 
                        0);

    if (!bResult)
    {
        PrintErrorText(TEXT("CryptSetKeyParam"),
                       dwError );
        return bResult;
    }
    return bResult;
}
