/************************************************************************
* Rutoken                                                               *
* Copyright (C) Aktiv Co. 2003 - 2014                                   *
*  :  http://www.rutoken.ru                          *
*  :    http://www.rutoken.ru/hotline/download/drivers/*
*  : http://www.rutoken.ru/hotline/                 *
*-----------------------------------------------------------------------*
*               *
*     Rutoken    Cert2Cont:          *
*  -    ;                                    * 
*  -     CERT_PUBLIC_KEY_INFO.              * 
************************************************************************/
    

#include "stdafx.h"
#include "Keys.h"
#include "Cert2Cont.h"
#include "Util_Funcs.h"


/************************************************************************
*                                              *
************************************************************************/
bool GetCryptKey(IN  HCRYPTPROV hCryptProv,
                 IN  DWORD      dwPreferredKeySpec,
                 OUT HCRYPTKEY& hCryptKey,
                 OUT DWORD&     dwSelectedKeySpec )
{
    bool      bResult            = true;           //       

    HCRYPTKEY hCryptKeyExchange  = NULL;           //        AT_KEYEXCHANGE
    HCRYPTKEY hCryptKeySignature = NULL;           //        AT_SIGNATURE
    
    DWORD     dwError            = ERROR_SUCCESS;  //      

    bool      bNeedToSelect      = false;          //  true,        
    DWORD     dwSelectedKey      = C2C_BAD_SELECT; //  .     
    

    /************************************************************************
    *                                     *
    *     AT_KEYEXCHANGE                        *
    ************************************************************************/
    bResult = (    CryptGetUserKey(hCryptProv,
                                   AT_KEYEXCHANGE,
                                   &hCryptKeyExchange )
                != FALSE );
    if (!bResult)
    {
        dwError = GetLastError();
        if (dwError == NTE_NO_KEY)
        {
            hCryptKeyExchange = NULL;
            bResult = true;
        }
        else
        {
            PrintErrorText(TEXT("CryptGetUserKey"),
                           dwError );
            return bResult;
        }
    }
    
    /************************************************************************
    *                                     *
    *     AT_SIGNATURE                          *
    ************************************************************************/
    bResult = (    CryptGetUserKey(hCryptProv,
                                   AT_SIGNATURE,
                                   &hCryptKeySignature )
                != FALSE );
    if (!bResult)
    {
        dwError = GetLastError();
        if (dwError == NTE_NO_KEY)
        {
            hCryptKeySignature = NULL;
            bResult = true;
        }
        else
        {
            PrintErrorText(TEXT("CryptGetUserKey"),
                           dwError );
            return bResult;
        }
    }
        
    bNeedToSelect = (   (hCryptKeyExchange != NULL)
                     && (hCryptKeySignature != NULL)
                     && (dwPreferredKeySpec == 0) );

    if (bNeedToSelect)
    {
        /************************************************************************
        *                          * 
        *                                             *
        ************************************************************************/
        _tprintf(TEXT("Select key:\n"));
        _tprintf(TEXT("[0] - AT_KEYEXCHANGE\n"));
        _tprintf(TEXT("[1] - AT_SIGNATURE\n"));

        if (_tscanf(TEXT("%d"), &dwSelectedKey) != 1)
        {
            _tprintf(TEXT("Input error.\n"));
            bResult = false;
        }
        else
        {
            switch (dwSelectedKey)
            {
            case 0:
                _tprintf(TEXT("You select AT_KEYEXCHANGE key.\n"));
                break;
            case 1:
                _tprintf(TEXT("You select AT_SIGNATURE key.\n"));
                break;
            default:
                _tprintf(TEXT("Input error.\n"));
                bResult = false;
                break;
            }
        }
    }
    else
    {
        /************************************************************************
        *                           *
        *     ,    *
        ************************************************************************/
        if (dwPreferredKeySpec)
            dwSelectedKey = dwPreferredKeySpec;
        else
        {
            if (   (hCryptKeyExchange != NULL)
                && (hCryptKeySignature == NULL))
            {
                dwSelectedKey = AT_KEYEXCHANGE;
            }
            if (   (hCryptKeyExchange == NULL)
                && (hCryptKeySignature != NULL))
            {
                dwSelectedKey = AT_SIGNATURE;
            }
        }
    }

    /************************************************************************
    *                            *
    *   AT_KEYEXCHANGE  AT_SIGNATURE                 *
    ************************************************************************/
    if (hCryptKeyExchange != NULL)
        CryptDestroyKey(hCryptKeyExchange);
    if (hCryptKeySignature != NULL)
        CryptDestroyKey(hCryptKeySignature);

    if (!bResult)
        return bResult;


    /************************************************************************
    *          *    
    ************************************************************************/
    switch (dwSelectedKey)
    {
    case AT_KEYEXCHANGE:
        bResult = (    CryptGetUserKey(hCryptProv,
                                       AT_KEYEXCHANGE,
                                       &hCryptKey )
                    != FALSE );
        dwError = GetLastError();
        if (!bResult)
            PrintErrorText(TEXT("CryptGetUserKey"),
                           dwError );
        dwSelectedKeySpec = AT_KEYEXCHANGE;
        break;
    case AT_SIGNATURE:
        bResult = (    CryptGetUserKey(hCryptProv,
                                       AT_SIGNATURE,
                                       &hCryptKey  )
                    != FALSE );
        dwError = GetLastError();
        if (!bResult)
            PrintErrorText(TEXT("CryptGetUserKey"),
                           dwError );
        dwSelectedKeySpec = AT_SIGNATURE;
        break;
    case C2C_BAD_SELECT:
        bResult = false;
        dwError = NTE_NO_KEY;
        PrintErrorText(TEXT("CryptGetUserKey"),
                       dwError );
        break;
    }

    return bResult;
}

/************************************************************************
*     CERT_PUBLIC_KEY_INFO;                  * 
************************************************************************/
bool GetPublicKeyBlobFromCryptProv( IN  HCRYPTPROV             hCryptProv,
                                    IN  DWORD                  dwKeySpec,
                                    OUT PCERT_PUBLIC_KEY_INFO& pInfo,
                                    OUT DWORD&                 dwInfoLen )
{
    bool  bResult = true;          //           
    DWORD dwError = ERROR_SUCCESS; //      


    /************************************************************************
    *      CERT_PUBLIC_KEY_INFO;           * 
    ************************************************************************/
    bResult = (    CryptExportPublicKeyInfo(hCryptProv,
                                            dwKeySpec,
                                            C2C_CERT_ENCODING,
                                            NULL,
                                            &dwInfoLen )
                != FALSE );

    dwError = GetLastError();
    bResult = (   bResult
               || (dwError == ERROR_MORE_DATA));
    if (!bResult)
    {
        PrintErrorText(TEXT("CryptExportKey"),
                       dwError );
        return bResult;
    }

    pInfo = (PCERT_PUBLIC_KEY_INFO)LocalAlloc(LMEM_ZEROINIT, dwInfoLen);

    /************************************************************************
    *     CERT_PUBLIC_KEY_INFO;                  * 
    ************************************************************************/
    bResult = (    CryptExportPublicKeyInfo(hCryptProv,
                                            dwKeySpec,
                                            C2C_CERT_ENCODING,
                                            pInfo,
                                            &dwInfoLen )
                != FALSE );
    if (!bResult)
    {
        dwError = GetLastError();
        FreeBuffer((LPVOID*)&pInfo);
        PrintErrorText(TEXT("CryptExportKey"),
                       dwError );
        return bResult;
    }

    return bResult;
}

