/************************************************************************
* Rutoken                                                               *
* Copyright (C) Aktiv Co. 2003 - 2014                                   *
*  :  http://www.rutoken.ru                          *
*  :    http://www.rutoken.ru/hotline/download/drivers/*
*  : http://www.rutoken.ru/hotline/                 *
*-----------------------------------------------------------------------*
*               *
*     Rutoken    Cert2Cont:          *
*  -     ;                               * 
*  -  ,    ;                 *
*  -    ;                                       *
*  -   .                              *
************************************************************************/
    
#include "stdafx.h"
#include "Util_Funcs.h"
#include "Cert2Cont.h"
#include <atlbase.h>
#include <atlconv.h>


/************************************************************************
*                                                 *
************************************************************************/
void PrintWelcomeInformation()
{
    _tprintf(TEXT("\nRutoken project| 2014  (C) Aktiv Co. | www.rutoken.ru\n"));
    _tprintf(TEXT("Welcome to \"Certificate import to container utility\".\n\n"));
}

/************************************************************************
*                                        *
************************************************************************/
void PrintHelpInformation()
{
    _tprintf(TEXT("\nCert2Cont    [/p <CSP_Name>] [/c <Container_Name>]\n"));
    _tprintf(TEXT("        [/k AT_KEYEXCHANGE|AT_SIGNATURE] [/f <Der_Cer_File_Name>]\n"));
    _tprintf(TEXT("        [/?]\n"));
    _tprintf(TEXT("    /? - print this help;\n"));
    _tprintf(TEXT("    /p - CSP name, for example \"Aktiv Rutoken CSP v1.0\";\n"));
    _tprintf(TEXT("    /c - CSP key container name, for example\n"));
    _tprintf(TEXT("        \"{C4169872-D881-4154-8C8B-B1B2B7021BFF}\";\n"));
    _tprintf(TEXT("    /k - Identifies the key pair to use from the key container.\n"));
    _tprintf(TEXT("        It can be \"AT_KEYEXCHANGE\" or \"AT_SIGNATURE\".\n"));
    _tprintf(TEXT("    /f - DER certificate file name.\n\n"));
    _tprintf(TEXT("!!!Parameters with spaces should be used in quotes.\n\n"));
    _tprintf(TEXT("Example:\n"));
    _tprintf(TEXT("C:\\Cert2Cont.exe /p \"Aktiv Rutoken CSP v1.0\" /f \"C:\\cert.cer\"\n"));
    _tprintf(TEXT("    /c {C4169872-D881-4154-8C8B-B1B2B7021BFF} /k AT_KEYEXCHAGE \n\n"));
}

/************************************************************************
*  ,                 *
************************************************************************/
bool ParseCommandLine( IN  int     argc,
                       IN  _TCHAR* argv[],
                       OUT LPTSTR& lpszCSP,
                       OUT LPTSTR& lpszContainer,
                       OUT DWORD&  dwKeySpec,
                       OUT LPTSTR& lpszCertFileName,
                       OUT bool&   bPrintHelpAndExit)
{
    bool   bResult         = true; //       
    
    DWORD  dwIndex         = 0;    //   

    LPTSTR lpszCurCmdParam = NULL; //       

    bPrintHelpAndExit = false;

    lpszCurCmdParam = (LPTSTR) LocalAlloc(LMEM_ZEROINIT, sizeof(TCHAR) * MAX_PATH);
    

    for (dwIndex = 1;
         dwIndex < ((DWORD)argc);
         dwIndex += 2 )
    {
        _tcscpy(lpszCurCmdParam,
                argv[dwIndex] );
        _tcslwr(lpszCurCmdParam );

        /************************************************************************
        *   "/?"                                        *
        ************************************************************************/
        if (    ::memcmp(   lpszCurCmdParam,
                            C2C_CMD_ARG_HELP,
                            ((_tcsclen(C2C_CMD_ARG_HELP) + 1)* sizeof(TCHAR)) )
                == 0 )
        {
            PrintHelpInformation();
            bPrintHelpAndExit = true;
            break;
        }

        /************************************************************************
        *   "/p"                                        *
        ************************************************************************/
        if (    ::memcmp(   lpszCurCmdParam,
                            C2C_CMD_ARG_CSP,
                            ((_tcsclen(C2C_CMD_ARG_CSP) + 1)* sizeof(TCHAR)) )
                == 0 )
        {
            if (    ((dwIndex + 1) < (DWORD)argc)
                &&  (argv[dwIndex + 1]) )
            {
                lpszCSP = (LPTSTR) LocalAlloc(LMEM_ZEROINIT, ((_tcslen(argv[dwIndex + 1]) + 1) * sizeof(TCHAR)) );

                ::CopyMemory(   lpszCSP,
                                argv[dwIndex + 1],
                                ((_tcslen(argv[dwIndex + 1]) + 1) * sizeof(TCHAR)));
            }
            else
            {
                _tprintf(TEXT("Error in command line.\n"));
                PrintHelpInformation();
                bResult = false;
                break;
            }
                
                ::ZeroMemory(lpszCurCmdParam,
                             (sizeof(TCHAR) * MAX_PATH ));
            continue;
        }

        /************************************************************************
        *   "/c"                                        *
        ************************************************************************/
        if (    ::memcmp(   lpszCurCmdParam,
                            C2C_CMD_ARG_CONTAINER,
                            ((_tcsclen(C2C_CMD_ARG_CONTAINER) + 1)* sizeof(TCHAR)) )
                == 0 )
        {
            if (    ((dwIndex + 1) < (DWORD)argc)
                &&  (argv[dwIndex + 1]) )
            {
                lpszContainer = (LPTSTR) LocalAlloc(LMEM_ZEROINIT, ((_tcslen(argv[dwIndex + 1]) + 1) * sizeof(TCHAR)) );

                ::CopyMemory(   lpszContainer,
                                argv[dwIndex + 1],
                                ((_tcslen(argv[dwIndex + 1]) + 1) * sizeof(TCHAR)) );
            }
            else
            {
                _tprintf(TEXT("Error in command line.\n"));
                PrintHelpInformation();
                bResult = false;
                break;
            }

            ::ZeroMemory(lpszCurCmdParam,
                         (sizeof(TCHAR) * MAX_PATH));
            continue;
        }
        
        /************************************************************************
        *   "/k"                                        *
        ************************************************************************/
        if (    ::memcmp(lpszCurCmdParam,
                         C2C_CMD_ARG_KEYSPEC,
                         ((_tcsclen(C2C_CMD_ARG_KEYSPEC) + 1)* sizeof(TCHAR)) )
                == 0 )
        {
            dwKeySpec = 0;

            if (    ((dwIndex + 1) < (DWORD)argc)
                &&  (argv[dwIndex + 1]) )
            {
                if (    ::memcmp( argv[dwIndex + 1],
                                  C2C_CMD_ARG_KEYSPEC_AT_KEYEXCHANGE,
                                  ((_tcsclen(C2C_CMD_ARG_KEYSPEC_AT_KEYEXCHANGE) + 1)* sizeof(TCHAR)) )
                        == 0)
                    dwKeySpec = AT_KEYEXCHANGE;

                if (    ::memcmp( argv[dwIndex + 1],
                                  C2C_CMD_ARG_KEYSPEC_AT_SIGNATURE,
                                  ((_tcsclen(C2C_CMD_ARG_KEYSPEC_AT_SIGNATURE) + 1)* sizeof(TCHAR)) )
                        == 0)
                    dwKeySpec = AT_SIGNATURE;
            }
            else
            {
                _tprintf(TEXT("Error in command line.\n"));
                PrintHelpInformation();
                bResult = false;
                break;
            }

            if (dwKeySpec == 0)
            {
                _tprintf(TEXT("Error in command line.\n"));
                PrintHelpInformation();
                bResult = false;
                break;
            }

            ::ZeroMemory( lpszCurCmdParam,
                          (sizeof(TCHAR) * MAX_PATH));
            continue;
        }

        /************************************************************************
        *   "/f"                                        *
        ************************************************************************/
        if (    ::memcmp( lpszCurCmdParam,
                          C2C_CMD_ARG_CERFILE,
                          ((_tcsclen(C2C_CMD_ARG_CERFILE) + 1)* sizeof(TCHAR)) )
                == 0 )
        {
            if (    ((dwIndex + 1) < (DWORD)argc)
                &&  (argv[dwIndex + 1]) )
            {
                lpszCertFileName = (LPTSTR) LocalAlloc(LMEM_ZEROINIT, ((_tcslen(argv[dwIndex + 1]) + 1) * sizeof(TCHAR)) );

                ::CopyMemory(lpszCertFileName,
                             argv[dwIndex + 1],
                             ((_tcslen(argv[dwIndex + 1]) + 1) * sizeof(TCHAR)) );
            }
            else
            {
                _tprintf(TEXT("Error in command line.\n"));
                PrintHelpInformation();
                bResult = false;
                break;
            }

            ::ZeroMemory(lpszCurCmdParam,
                         (sizeof(TCHAR) * MAX_PATH));
            continue;
        }

        _tprintf(TEXT("Error in command line.\n"));
        PrintHelpInformation();
        bResult = false;
        break;
    }

    LocalFree(lpszCurCmdParam);
    return bResult;
}

/************************************************************************
*  ,    ,           *
*                                             *
************************************************************************/
void FreeCommandLineParameters( IN OUT LPTSTR& lpszCSP,
                                IN OUT LPTSTR& lpszContainer,
                                IN OUT DWORD&  dwKeySpec,
                                IN OUT LPTSTR& lpszCertFileName )
{
    /************************************************************************
    *  ,      *
    ************************************************************************/
    if (lpszCSP)
    {
        LocalFree(lpszCSP);
        lpszCSP = NULL;
    }

    /************************************************************************
    *  ,            *
    ************************************************************************/
    if (lpszContainer)
    {
        LocalFree(lpszContainer);
        lpszContainer = NULL;
    }

    /************************************************************************
    *                *
    ************************************************************************/
    dwKeySpec = 0;
    
    /************************************************************************
    *  ,       ,  *   
    *                                                  *
    ************************************************************************/
    if (lpszCertFileName)
    {
        LocalFree(lpszCertFileName);
        lpszCertFileName = NULL;
    }
}

/************************************************************************
*                                               *
************************************************************************/
bool ReadCertificateFromFile( IN  LPCTSTR lpszPreferredFile,
                              OUT LPVOID& lpvCertBuffer,
                              OUT DWORD&  dwCertBufferSize )
{
    bool   bResult          = true;          //       

    HANDLE hCertFile        = NULL;          //  ,  
    LPTSTR lpszCertFileName = NULL;          //        
    DWORD  dwBytesRead      = 0;             //    

    DWORD  dwError          = ERROR_SUCCESS; //          
        
    lpszCertFileName = (LPTSTR) LocalAlloc(LMEM_ZEROINIT, sizeof(TCHAR) * MAX_PATH);

    if (lpszPreferredFile)
    {
        _tcscpy(lpszCertFileName,
                lpszPreferredFile );
    }
    else
    {
        _tprintf(TEXT("Enter der-certificate file name:\n"));
        if (_tscanf(TEXT("%s"), lpszCertFileName, (MAX_PATH - 1) ) != 1)
        {
            _tprintf(TEXT("Input error.\n"));
            bResult = false;
            LocalFree(lpszCertFileName);
            return bResult;
        }
    }

    /************************************************************************
    *  ,                                     *
    ************************************************************************/
    hCertFile = CreateFile( lpszCertFileName,
                            GENERIC_READ,
                            FILE_SHARE_READ,
                            NULL,
                            OPEN_EXISTING,
                            0,
                            NULL );
    bResult = (hCertFile != INVALID_HANDLE_VALUE);
    dwError = GetLastError();
    LocalFree(lpszCertFileName);
    if (!bResult)
    {
        PrintErrorText(TEXT("CreateFile"),
                       dwError );
        return bResult;
    }

    /************************************************************************
    *   ,                           *
    ************************************************************************/
    dwCertBufferSize = GetFileSize(hCertFile,NULL);
    bResult = (dwCertBufferSize != INVALID_FILE_SIZE);
    if (!bResult)
    {
        dwError = GetLastError();
        dwCertBufferSize = 0;
        PrintErrorText(TEXT("GetFileSize"),
                       dwError );
        return bResult;
    }

    lpvCertBuffer = (LPVOID) LocalAlloc(LMEM_ZEROINIT, dwCertBufferSize);

    /************************************************************************
    *                              *
    ************************************************************************/
    bResult = (    ReadFile(hCertFile,
                            lpvCertBuffer,
                            dwCertBufferSize,
                            &dwBytesRead,
                            NULL )
                != FALSE );
    if (!bResult)
    {
        dwError = GetLastError();
        PrintErrorText( TEXT("ReadFile"),
                        dwError );
        return bResult;
    }

    return bResult;
}

/************************************************************************
*  ,             *
************************************************************************/
void FreePointersList( IN LPVOID* lppvPointersList,
                       IN DWORD   dwPointersCount )
{
    DWORD dwIndex = 0; //  

    for (   dwIndex = 0;
            dwIndex < dwPointersCount;
            dwIndex++ )
    {
        LocalFree( (HLOCAL)*(intptr_t*)((intptr_t)lppvPointersList + (sizeof(intptr_t)*dwIndex)));
    }

    ::ZeroMemory( lppvPointersList,
                  (sizeof(intptr_t)*C2C_MAX_ENUM_COUNT));
}

/************************************************************************
*                                                      *
************************************************************************/
void FreeBuffer( IN OUT LPVOID* lppvBuffer)
{
    if (*lppvBuffer != NULL)
    {
        LocalFree(*lppvBuffer);
        *lppvBuffer = NULL;
    }
}

/************************************************************************
*                                           *
************************************************************************/
void PrintErrorText( IN LPTSTR lpszText,
                     IN DWORD  dwError )
{
    _tprintf(TEXT("Error - %s. Error code: 0x%X\n"), lpszText, dwError);

    LPTSTR lpszError_Text = NULL;
    FormatMessage(  FORMAT_MESSAGE_ALLOCATE_BUFFER | FORMAT_MESSAGE_FROM_SYSTEM,
                    NULL,
                    dwError,
                    MAKELANGID(LANG_NEUTRAL, SUBLANG_DEFAULT),
                    (LPTSTR) &lpszError_Text,
                    0,
                    NULL );
    _tprintf(TEXT("Error description: %s\n"), lpszError_Text);
    LocalFree(lpszError_Text);
}
