#import <Foundation/Foundation.h>

typedef enum _ReaderStatus {
	kValidReader,
	kNoMediaReader,
	kErrorReader
} ReaderStatus;

@interface CPReader : NSObject
@property (strong, readwrite) NSString* nickname;
@property (strong, readwrite) NSString* name;
@property (strong, readwrite) NSString* media;
@property (assign, readwrite) uint8_t flags;

-(CPReader*) initWithData:(uint8_t*)dataPtr;
-(ReaderStatus)getReaderStatus;
-(bool)isRutoken;
-(NSComparisonResult)localizedCaseInsensitiveCompare:(CPReader *)reader;
@end