#import "CPReader.h"

@implementation CPReader

@synthesize name;
@synthesize nickname;
@synthesize media;
@synthesize flags;

-(CPReader*) init {
    self = [super init];
    self.name = nil;
    self.nickname = nil;
    self.media = nil;
    return self;
}

-(CPReader*) initWithData: (uint8_t*)dataPtr {
    self = [super init];
    self.nickname = [[NSString alloc] initWithBytes:dataPtr length:strlen((char*)dataPtr) encoding:NSUTF8StringEncoding];
    dataPtr+=1+[self.nickname length];
    self.name = [[NSString alloc] initWithBytes:dataPtr length:strlen((char*)dataPtr) encoding:NSUTF8StringEncoding];
    dataPtr+=1+[self.name length];
    self.media = [[NSString alloc] initWithBytes:dataPtr length:strlen((char*)dataPtr) encoding:NSUTF8StringEncoding];
    dataPtr+=1+[self.name length];
    self.flags = *dataPtr;
    return self;
}

-(ReaderStatus)getReaderStatus {
    NSMutableArray* filteredList = nil;
	NSArray* invalidStrings = [[NSArray alloc] initWithObjects:@"NO_UNIQUE", @"INVALID_MEDIA", @"IS_FKC", @"NO_FKC", nil];
	NSString* noMediaString = @"NO_MEDIA";
    
    for (NSString* str in invalidStrings) {
        if ([[self media] rangeOfString:str].location != NSNotFound) {
            return kErrorReader;
        }
    }
	
	if ([[self media] rangeOfString:noMediaString].location != NSNotFound) {
		return kNoMediaReader;
	}
	
    return kValidReader;
}

-(bool)isRutoken {
	return [[self name] rangeOfString:@"Rutoken ECP BT"].location != NSNotFound;
}

-(NSComparisonResult)localizedCaseInsensitiveCompare:(CPReader *)reader {
	return [[self name] localizedCaseInsensitiveCompare:[reader name]];
}

@end