#import "CryptoPro.h"
#import "CPReader.h"

static const int kGostProvType = PROV_GOST_2001_DH;

@implementation CryptoPro

+(NSArray*)getReaderList
{
    NSMutableArray* readerList = nil;
    
    DWORD error = ERROR_SUCCESS;
    HCRYPTPROV  hCryptProv = 0;
    CSP_BOOL	bResult = 0;
    DWORD       dwLen = 0;
    
	@try {
		bResult = CryptAcquireContext(&hCryptProv, NULL, NULL, kGostProvType, CRYPT_VERIFYCONTEXT);
		if (!bResult) {
			error = CSP_GetLastError();
			THROW_ERROR(error);
		}
		
		if(0 == hCryptProv) {
			[self logData:@"Invalid hCryptProv"];
			return nil;
		}
		
		BYTE cryptFirst = CRYPT_FIRST;
		
		for (;1;) {
			
			CSP_SetLastError(ERROR_SUCCESS);
			bResult = CryptGetProvParam(hCryptProv, PP_ENUMREADERS, NULL, &dwLen, CRYPT_MEDIA | cryptFirst);
			error = CSP_GetLastError();
			if (error == ERROR_NO_MORE_ITEMS)
				break;
			if (!bResult)
			{
				[self logData: [NSString stringWithFormat:@"CryptGetProvParam(PP_ENUMREADERS, LEN): %x\n", error]];
				THROW_ERROR(error);
			}
			
			NSMutableData* data = [[NSMutableData alloc] initWithCapacity:dwLen];
			
			CSP_SetLastError(ERROR_SUCCESS);
			bResult = CryptGetProvParam(hCryptProv, PP_ENUMREADERS, (BYTE*)[data bytes], &dwLen, CRYPT_MEDIA | cryptFirst);
			cryptFirst = 0;
			error = CSP_GetLastError();
			if (error == ERROR_NO_MORE_ITEMS)
				break;
			if (!bResult)
			{
				[self logData: [NSString stringWithFormat:@"CryptGetProvParam(PP_ENUMREADERS, LEN): %x\n", error]];
				THROW_ERROR(error);
			}
			
			BYTE* dataPtr = (BYTE*)[data bytes];
			CPReader* reader = [[CPReader alloc] initWithData:dataPtr];
			
			if (nil == readerList) {
				readerList =[NSMutableArray new];
			}
			
			[readerList addObject: reader];
		}
	} @catch(ApplError* e) {};
	
	if (hCryptProv)
		CryptReleaseContext(hCryptProv, 0);
	
    return readerList;
}

+(NSArray*)getContainerList
{
    NSMutableArray* containerList = nil;
    
    DWORD error = ERROR_SUCCESS;
    HCRYPTPROV  hCryptProv = 0;
    CSP_BOOL	bResult = 0;
    DWORD       dwLen = 0;
    
	@try {
		bResult = CryptAcquireContext(&hCryptProv, NULL, NULL, kGostProvType, CRYPT_VERIFYCONTEXT);
		if (!bResult) {
			error = CSP_GetLastError();
			THROW_ERROR(error);
		}
		
		if(0 == hCryptProv) {
			[self logData:@"Invalid hCryptProv"];
			return nil;
		}
		
		BYTE cryptFirst = CRYPT_FIRST;
		
		for (;1;) {
			
			CSP_SetLastError(ERROR_SUCCESS);
			bResult = CryptGetProvParam(hCryptProv, PP_ENUMCONTAINERS, NULL, &dwLen, CRYPT_MEDIA | cryptFirst);
			error = CSP_GetLastError();
			if (error == ERROR_NO_MORE_ITEMS)
				break;
			if (!bResult)
			{
				[self logData: [NSString stringWithFormat:@"CryptGetProvParam(PP_ENUMREADERS, LEN): %x\n", error]];
				THROW_ERROR(error);
			}
			
			NSMutableData* data = [[NSMutableData alloc] initWithCapacity:dwLen];
			
			CSP_SetLastError(ERROR_SUCCESS);
			bResult = CryptGetProvParam(hCryptProv, PP_ENUMCONTAINERS, (BYTE*)[data bytes], &dwLen, CRYPT_MEDIA | cryptFirst);
			cryptFirst = 0;
			error = CSP_GetLastError();
			if (error == ERROR_NO_MORE_ITEMS)
				break;
			if (!bResult)
			{
				[self logData: [NSString stringWithFormat:@"CryptGetProvParam(PP_ENUMREADERS, LEN): %x\n", error]];
				THROW_ERROR(error);
			}
			
			char* dataPtr = (char*)[data bytes];
			NSString* container = [NSString stringWithCString:dataPtr encoding:NSASCIIStringEncoding];
			
			if (nil == containerList) {
				containerList =[NSMutableArray new];
			}
			
			[containerList addObject: container];
		}
	} @catch(ApplError* e) {};
	
	if (hCryptProv)
		CryptReleaseContext(hCryptProv, 0);
	
    return containerList;
}

+(DWORD)createNewKeyset:(NSString*)name forReader:(CPReader*) reader {
    NSMutableString* containerName = nil;
    DWORD error = ERROR_SUCCESS;
    HCRYPTPROV  hCryptProv = 0;
	HCRYPTKEY hKey = 0;   
    CSP_BOOL	bResult = 0;
	LPSTR pszUserName = NULL;		  // Буфер для хранения имени  ключевого контейнера.
    DWORD dwUserNameLen;
    
    containerName = [NSMutableString stringWithString:@"\\\\.\\"];
    [containerName appendString:[reader name]];
    [containerName appendString:@"\\"];
    [containerName appendString:name];
	
	@try {
		bResult = CryptAcquireContext(&hCryptProv, [containerName cStringUsingEncoding:NSASCIIStringEncoding], "Crypto-Pro GOST R 34.10-2001 KC1 CSP", kGostProvType, CRYPT_NEWKEYSET);
        
		if (!bResult) {
			error = CSP_GetLastError();
			[self logData:[NSString stringWithFormat:@"CryptAcquireContext(CRYPT_VERIFYCONTEXT): %x\n", error]];
			THROW_ERROR(error);
		}
		
		if(!CryptGetProvParam(
							  hCryptProv,               // Дескриптор CSP
							  PP_CONTAINER,             // Получение имени ключевого контейнера
							  NULL,		          // Указатель на имя ключевого контейнера
							  &dwUserNameLen,           // Длина имени
							  0))
		{
			// Ошибка получении имени ключевого контейнера
			THROW_ERROR(error);
		}
		
		// Лучше использовать auto_ptr:
		//std::auto_ptr<char> aptrUserName(new char[dwUserNameLen+1]);
		//szUserName = aptrUserName.get();
		pszUserName=(char *)malloc((dwUserNameLen+1));
		
		if(!CryptGetProvParam(
							  hCryptProv,               // Дескриптор CSP
							  PP_CONTAINER,             // Получение имени ключевого контейнера
							  (LPBYTE)pszUserName,	  // Указатель на имя ключевого контейнера
							  &dwUserNameLen,           // Длина имени
							  0))
		{
			// Ошибка получении имени ключевого контейнера
			THROW_ERROR(CSP_GetLastError());
		}
		
		printf("A crypto context has been acquired and \n");
		printf("The name on the key container is %s\n\n", pszUserName);
		free(pszUserName);
		
		// Контекст с ключевым контейнером доступен,
		// попытка получения дескриптора ключа подписи
		if(CryptGetUserKey(
						   hCryptProv,                     // Дескриптор CSP
						   AT_SIGNATURE,                   // Спецификация ключа
						   &hKey))                         // Дескриптор ключа
		{
			printf("A signature key is available.\n");
		}
		else
		{
			printf("No signature key is available.\n");
			error =CSP_GetLastError();
			// Ошибка в том, что контейнер не содержит ключа.
			if(error != (DWORD)NTE_NO_KEY) {
				printf("An error other than NTE_NO_KEY getting signature key.\n");
				THROW_ERROR(error);
			}
			
			// Создание подписанной ключевой пары.
			printf("The signature key does not exist.\n");
			printf("Creating a signature key pair...\n");
			
			if(!CryptGenKey(
							hCryptProv,
							AT_SIGNATURE,
							0,
							&hKey))
			{
				printf("Error occurred creating a signature key.\n");
				error=CSP_GetLastError();
				THROW_ERROR(error);
			}
			printf("Created a signature key pair.\n");
			
		}
		
		//проверка ключа обмена:
		if(CryptGetUserKey(
						   hCryptProv,
						   AT_KEYEXCHANGE,
						   &hKey))
		{
			printf("An exchange key exists. \n");
		}
		else
		{
			printf("No exchange key is available.\n");
			
			error=CSP_GetLastError();
			// Проверка на то, нужно ли что-либо создавать.
			if(error != (DWORD)NTE_NO_KEY) {
				printf("Error occurred attempting to create an exchange key.\n");
				THROW_ERROR(error);
			}
			
			// Создание ключевой пары обмена.
			printf("The exchange key does not exist.\n");
			printf("Attempting to create an exchange key pair.\n");
			
			if(!CryptGenKey(
							hCryptProv,
							AT_KEYEXCHANGE,
							0,
							&hKey))
			{
				printf("Error occurred attempting to create an exchange key.\n");
				error=CSP_GetLastError();
				THROW_ERROR(error);
			}
			printf("Exchange key pair created.\n");
		}
		
		error = ERROR_SUCCESS;
		
		[self logData:[NSString stringWithFormat:@"A signature key pair and an exchange key now exist in container"]];
	} @catch (ApplError* e) {
		error=[e code];
	};
	
	if(hKey)
		CryptDestroyKey(hKey);
    if(hCryptProv)
		CryptReleaseContext(hCryptProv, 0);
	if(pszUserName)
		free(pszUserName);

    return error;
}
@end
