#import <Foundation/Foundation.h>

@interface ApplError : NSError
+ (id)errorWithCode:(unsigned long)code;
@end

#define THROW_ERROR(CODE) \
do { \
[self logData: [NSString stringWithFormat:@"%s:%d: error in %s: 0x%lx", __FILE__, __LINE__, __FUNCTION__, CODE]]; \
NSLog(@"%s:%d: error in %s: 0x%lx", __FILE__, __LINE__, __FUNCTION__, CODE); \
@throw [ApplError errorWithCode : CODE]; \
} while (0)

@interface DataLogger : NSObject
+ (void)logData:(NSString*)data;
@end