//  Copyright (c) 2014 Aktiv Co. All rights reserved.

#import "ViewController.h"
#import "Pkcs11.h"
#import "CryptoPro.h"

NSString* kSmInitAlertTitle=@"SM Activation";
NSString* kContainerCreateAlertTitle=@"Create container";

@interface ViewController ()
- (void) setTxtValue:(NSString*) data;
- (void) addTxtValue:(NSString*) data;
@end

@implementation ViewController

- (NSInteger)numberOfComponentsInPickerView:
(UIPickerView *)pickerView
{
    return 1;
}

- (NSInteger)pickerView:(UIPickerView *)pickerView
numberOfRowsInComponent:(NSInteger)component
{
	if(nil != readers && [readers count] > 0)
        return [readers count];
    else
        return 1;
}

- (UIView *)pickerView:(UIPickerView *)pickerView
             viewForRow:(NSInteger)row
            forComponent:(NSInteger)component
		   reusingView: (UIView *)view
{
	NSString* title=nil;
    if(nil != readers && [readers count] > 0)
	{
		CPReader* reader = [readers objectAtIndex:row];
		ReaderStatus status = [reader getReaderStatus];
		NSString* statusString = nil;
		switch(status) {
			case kValidReader:
				statusString = @"( RDY )";
				break;
			case kNoMediaReader:
				statusString = @"( !SM )";
				break;
			case kErrorReader:
				statusString = @"( ERR )";
				break;
		}
        title=[NSString stringWithFormat:@"%@   %@", statusString, [reader name]];
	}
    else
        title=@"No readers";
	UILabel *label = [[UILabel alloc] initWithFrame:CGRectMake(0, 0, pickerView.frame.size.width, 44)];
    label.font = [UIFont fontWithName:@"HelveticaNeue-Bold" size:12];
    label.text = [NSString stringWithFormat:@"    %@", title];
    return label;
}

-(void)pickerView:(UIPickerView *)pickerView didSelectRow:(NSInteger)row
      inComponent:(NSInteger)component
{
    currentToken = nil;
	if(nil != readers && [readers count] > 0 && row<[readers count]){ 
		CPReader* reader = [readers objectAtIndex:row];
		currentToken=reader;
	}
}

- (void)viewDidLoad
{
    [super viewDidLoad];
    _picker.frame=CGRectMake(_picker.frame.origin.x, _picker.frame.origin.y, _picker.frame.size.width, 162);
    
    [[NSNotificationCenter defaultCenter] addObserver:self selector:@selector(logData:)
                                                 name:@"LogData" object:_pkcs11];
    
    [self addTxtValue:@"This is a sample application linked with rtPKCS11ECP library by Aktiv Co"];
    [self addTxtValue:@"Use \"Update token list\" button to enumerate availible tokens"];
    [self addTxtValue:@"Use \"Get token info\" and \"Get ex token info\" buttons to view token info"];
    
    [self UpdateTokens:self];
}

- (BOOL)shouldAutorotateToInterfaceOrientation:(UIInterfaceOrientation)interfaceOrientation
{
    if ([[UIDevice currentDevice] userInterfaceIdiom] == UIUserInterfaceIdiomPhone) {
        return (interfaceOrientation != UIInterfaceOrientationPortraitUpsideDown);
    } else {
        return YES;
    }
}

- (void) setTxtValue:(NSString*) data
{
    _txtData.text = data;
    [_txtData flashScrollIndicators];
    NSRange range = NSMakeRange(_txtData.text.length - 1, 1);
    [_txtData scrollRangeToVisible:range];
}

- (void) addTxtValue:(NSString*) data
{
    NSString *textValue = [NSString stringWithFormat:@"%@\n%@", _txtData.text, data];
    [self setTxtValue:textValue];
}

- (IBAction)UpdateTokens:(id)sender {
    [self addTxtValue:@"Update token list"];
    
    readers = [CryptoPro getReaderList];
    
    if (readers != nil && [readers count] != 0) {
        [self addTxtValue:@"Tokens availible:"];
        NSArray* serials = [readers sortedArrayUsingSelector:@selector(localizedCaseInsensitiveCompare:)];
        for(size_t i = 0; i < [serials count]; ++i) {
            [self addTxtValue:[NSString stringWithFormat:@"%@ %@",[[serials objectAtIndex:i] name],[[serials objectAtIndex:i] media]]];
        }
    }

    [_picker reloadAllComponents];
    [self pickerView:_picker
        didSelectRow:[_picker selectedRowInComponent:0]
         inComponent:0];
}

- (IBAction)StartSM:(id)sender {
    [self addTxtValue:@"Init SM channel"];
	if(![currentToken isRutoken]) {
		UIAlertView * alert = [[UIAlertView alloc] initWithTitle:kSmInitAlertTitle message:@"Error! This is not rutoken!" delegate:nil cancelButtonTitle:@"OK" otherButtonTitles:nil];
		alert.alertViewStyle = UIAlertViewStyleDefault;
		[alert show];
	} else if([currentToken getReaderStatus] == kValidReader) {
		UIAlertView * alert = [[UIAlertView alloc] initWithTitle:kSmInitAlertTitle message:@"Error! This rutoken does not need initializing SM channel" delegate:nil cancelButtonTitle:@"OK" otherButtonTitles:nil];
		alert.alertViewStyle = UIAlertViewStyleDefault;
		[alert show];
	} else {
		UIAlertView * alert = [[UIAlertView alloc] initWithTitle:kSmInitAlertTitle message:@"Please, be kind to provide SM activation password" delegate:self cancelButtonTitle:@"OK" otherButtonTitles:nil];
		alert.alertViewStyle = UIAlertViewStylePlainTextInput;
		[alert show];
	}
}

- (void)alertView:(UIAlertView *)alertView clickedButtonAtIndex:(NSInteger)buttonIndex{
	if([[alertView title] rangeOfString:kSmInitAlertTitle].location != NSNotFound ){
		[PKCS11 setActivationPassword: [[alertView textFieldAtIndex:0] text] forReader:[currentToken name]];
	}
}

- (IBAction)CreateContainer:(id)sender {
    [self addTxtValue:@"Create container"];
	if([currentToken getReaderStatus] != kValidReader) {
		UIAlertView * alert = [[UIAlertView alloc] initWithTitle:kContainerCreateAlertTitle message:@"Error! This reader seems to be not valid yet!" delegate:nil cancelButtonTitle:@"OK" otherButtonTitles:nil];
		alert.alertViewStyle = UIAlertViewStyleDefault;
		[alert show];
	} else {
		CFUUIDRef uuid = CFUUIDCreate(NULL);
		CFStringRef str = CFUUIDCreateString(NULL, uuid);
		CFRelease(uuid);
		[self addTxtValue:[NSString stringWithFormat:@"Creating container %@", (__bridge NSString*)str]];
		[CryptoPro createNewKeyset:(__bridge NSString*)str forReader:currentToken];
		[self ListContainers: self];
	}
}

- (IBAction)ListContainers:(id)sender {
    [self addTxtValue:@"List containers"];
		
	NSArray* containers = [CryptoPro getContainerList];
	[self addTxtValue:@"Containers availible:"];
	for (NSString* container in containers)
		[self addTxtValue:container];
}


- (void)logData:(NSNotification*)notification {
    NSDictionary* userInfo = [notification userInfo];
    NSString* data = [userInfo objectForKey:@"data"];
    [self addTxtValue:data];
    
}
@end
