//  Copyright (c) 2014 Aktiv Co. All rights reserved.

#import <Foundation/Foundation.h>

#import <RtPKCS11ECP/rtpkcs11.h>

@interface DataLogger : NSObject
- (void)logData:(NSString*)data;
@end

@interface Pkcs11Error : NSError
+ (id)errorWithCode:(CK_ULONG)code;
@end

#define THROW_ERROR(CODE) \
do { \
[self logData: [NSString stringWithFormat:@"%s:%d: error in %s: 0x%lx", __FILE__, __LINE__, __FUNCTION__, CODE]]; \
NSLog(@"%s:%d: error in %s: 0x%lx", __FILE__, __LINE__, __FUNCTION__, CODE); \
@throw [Pkcs11Error errorWithCode : CODE]; \
} while (0)

@interface Token : DataLogger {
	CK_FUNCTION_LIST_PTR _functions;
	CK_FUNCTION_LIST_EXTENDED_PTR _extendedFunctions;
	CK_SLOT_ID _id;
}

@property(nonatomic, readonly) NSString* serialNumber;

- (NSDictionary*) getTokenInfo;

- (NSDictionary*) getTokenInfoEx;

@end


@interface Pkcs11 : DataLogger {
	CK_FUNCTION_LIST_PTR _functions;
	CK_FUNCTION_LIST_EXTENDED_PTR _extendedFunctions;
	NSMutableDictionary* _tokens;
	NSMutableDictionary* _serialSlotMap;
}

- (id)init;

- (void)updateTokenList;

- (BOOL)hasToken;

- (NSArray*)serialNumbers;

- (Token*)tokenForSerialNumber:(NSString*)serialNumber;

@end
