//  Copyright (c) 2014 Aktiv Co. All rights reserved.

#import "ViewController.h"
#import "Pkcs11.h"

@interface ViewController ()
- (void) setTxtValue:(NSString*) data;
- (void) addTxtValue:(NSString*) data;
@end

@implementation ViewController

- (NSInteger)numberOfComponentsInPickerView:
(UIPickerView *)pickerView
{
    return 1;
}

- (NSInteger)pickerView:(UIPickerView *)pickerView
numberOfRowsInComponent:(NSInteger)component
{
    if ([_pkcs11 hasToken])
        return [_pkcs11 serialNumbers].count;
    else
        return 1;
}

- (NSString *)pickerView:(UIPickerView *)pickerView
             titleForRow:(NSInteger)row
            forComponent:(NSInteger)component
{
    if(row < [_pkcs11 serialNumbers].count)
        return [_pkcs11 serialNumbers][row];
    else
        return @"No tokens";
}

-(void)pickerView:(UIPickerView *)pickerView didSelectRow:(NSInteger)row
      inComponent:(NSInteger)component
{
    currentToken = [self pickerView: pickerView titleForRow:row forComponent:component];
}

- (void)viewDidLoad
{
    [super viewDidLoad];
    _picker.frame=CGRectMake(_picker.frame.origin.x, _picker.frame.origin.y, _picker.frame.size.width, 162);
    _pkcs11 = [[Pkcs11 alloc] init];
    currentToken = @"No tokens";
    
    [[NSNotificationCenter defaultCenter] addObserver:self selector:@selector(logData:)
                                                 name:@"LogData" object:_pkcs11];
    
    [self addTxtValue:@"This is a sample application linked with rtPKCS11ECP library by Aktiv Co"];
    [self addTxtValue:@"Use \"Update token list\" button to enumerate availible tokens"];
    [self addTxtValue:@"Use \"Get token info\" and \"Get ex token info\" buttons to view token info"];
    
    [self UpdateTokens:self];
}

- (BOOL)shouldAutorotateToInterfaceOrientation:(UIInterfaceOrientation)interfaceOrientation
{
    if ([[UIDevice currentDevice] userInterfaceIdiom] == UIUserInterfaceIdiomPhone) {
        return (interfaceOrientation != UIInterfaceOrientationPortraitUpsideDown);
    } else {
        return YES;
    }
}

- (void) setTxtValue:(NSString*) data
{
    _txtData.text = data;
    [_txtData flashScrollIndicators];
    NSRange range = NSMakeRange(_txtData.text.length - 1, 1);
    [_txtData scrollRangeToVisible:range];
}

- (void) addTxtValue:(NSString*) data
{
    NSString *textValue = [NSString stringWithFormat:@"%@\n%@", _txtData.text, data];
    [self setTxtValue:textValue];
}

- (IBAction)UpdateTokens:(id)sender {
    [self addTxtValue:@"Update token list"];
    @try {
        [_pkcs11 updateTokenList];
    } @catch(Pkcs11Error* e) {
        [self addTxtValue:[NSString stringWithFormat:@"Failed with %x", [e code]]];
    }
    
    if ([_pkcs11 hasToken]) {
        [self addTxtValue:@"Tokens availible:"];
        NSArray* serials = [[_pkcs11 serialNumbers] sortedArrayUsingSelector:@selector(localizedCaseInsensitiveCompare:)];
        for(size_t i = 0; i < [serials count]; ++i) {
            [self addTxtValue:[serials objectAtIndex:i]];
        }
    }

    [_picker reloadAllComponents];
    [self pickerView:_picker
        didSelectRow:[_picker selectedRowInComponent:0]
         inComponent:0];
}

- (IBAction)GetTokenInfo:(id)sender {
    [self addTxtValue:@"Get token info"];
    Token* token = [_pkcs11 tokenForSerialNumber:currentToken];
    if (token == nil) {
        [self addTxtValue:@"Token not found. Update token list first."];
    }
    
    [[NSNotificationCenter defaultCenter] addObserver:self selector:@selector(logData:)
                                                 name:@"LogData" object:token];
    @try {
        NSDictionary* dict = [token getTokenInfo];
        
        for(NSString* key in [dict allKeys]) {
            [self addTxtValue:[NSString stringWithFormat:@"%@: %@", key, [dict objectForKey:key]]];
        }
    } @catch(Pkcs11Error* e) {
        [self addTxtValue:[NSString stringWithFormat:@"Failed with %x", [e code]]];
    } @finally {
        [[NSNotificationCenter defaultCenter] removeObserver:self name:@"LogData" object:token];
    }
}

- (IBAction)GetTokenInfoEx:(id)sender {
    [self addTxtValue:@"Get extended token info"];
    Token* token = [_pkcs11 tokenForSerialNumber:currentToken];
    if (token == nil) {
        [self addTxtValue:@"Token not found. Update token list first."];
    }
    
    [[NSNotificationCenter defaultCenter] addObserver:self selector:@selector(logData:)
                                                 name:@"LogData" object:token];
    @try {
        NSDictionary* dict = [token getTokenInfoEx];
        
        for(NSString* key in [dict allKeys]) {
            [self addTxtValue:[NSString stringWithFormat:@"%@: %@", key, [dict objectForKey:key]]];
        }
    } @catch(Pkcs11Error* e) {
        [self addTxtValue:[NSString stringWithFormat:@"Failed with %x", [e code]]];
    } @finally {
        [[NSNotificationCenter defaultCenter] removeObserver:self name:@"LogData" object:token];
    }
}

- (void)logData:(NSNotification*)notification {
    NSDictionary* userInfo = [notification userInfo];
    NSString* data = [userInfo objectForKey:@"data"];
    [self addTxtValue:data];
    
}
@end
