/************************************************************************
* Rutoken                                                               *
* Copyright (C) Aktiv Co. 2003 - 2014                                   *
*  :  http://www.rutoken.ru                          *
*  :    http://www.rutoken.ru/hotline/download/drivers/*
*  : http://www.rutoken.ru/hotline/                 *
*-----------------------------------------------------------------------*
*    Rutoken   Rutoken Cryptographic Service      *
* Provider  C                                                         *
*-----------------------------------------------------------------------*
*            *
*-----------------------------------------------------------------------*
*     RSA- (   ),        *
*        B,     *
*                *
*       .                                *
*                                                                       *
*      :       *
*   c CryptoAPI    .             *
************************************************************************/

//    -   CAPI, :  
// #define _WIN32_WINNT 0x0400 

//  ,   Rutoken CSP
#include "rtCSP_Err.h"

#include <stdio.h>
#include <conio.h>
#include <tchar.h>
#include <windows.h>
#include <wincrypt.h>

#define MYPROV TEXT("Aktiv Rutoken CSP v1.0")

/************************************************************************
*                            *
************************************************************************/
void Error( IN char *s //    
            )
{
    _tprintf(_T("Error happened: %s\n"),s);
    _tprintf(_T("Error number: 0x%x\n"), GetLastError());
    _tprintf(_T("Exit program.\n"));
    getchar();
    exit(1);
}
/*    */
LPTSTR pszContainerName = TEXT("TestRtContainer");
/*  CSP */
HCRYPTPROV hCryptProv;
/*  RSA- */
HCRYPTKEY  hRSAKey;
/*      */
HCRYPTKEY  hPubKeyOnBComp;
/*     */
HCRYPTKEY  hSymKey;
/*     */
HCRYPTKEY  hSymKeyOnAComp; 

/*      */
BYTE* pbSymKeyBlob = NULL;
/*      */
BYTE* pbPubKeyBlob = NULL;
/*       */
DWORD dwSymKeyBlobLen;
/*       */
DWORD dwPubKeyBlobLen;
/*  */
DWORD dwError;


/************************************************************************
* Main()                                                                *
************************************************************************/

void main(void) 
{ 

    BOOL bResult = FALSE;

/*---------------------------------------------------------------------*/
/*  1 :      TestRtContainer,         */
/*            .                                      */
/*---------------------------------------------------------------------*/
     
    if( CryptAcquireContext(    &hCryptProv,    /* ([out])  CSP*/
                                pszContainerName,/*       */
                                MYPROV,         /*        */
                                PROV_RSA_FULL,  /*        */
                                CRYPT_NEWKEYSET)    )/*   */
    {
        _tprintf(_T("Container TestRtContainer has been created successfully.\n"));
    }
    else
    {
        dwError = GetLastError() ; 

        /*       :               */
        if(dwError == NTE_EXISTS) 
        {
            /*    :                             */
            if( CryptAcquireContext(    &hCryptProv, 
                                        pszContainerName, 
                                        MYPROV, 
                                        PROV_RSA_FULL, 
                                        0 ) )/*0 -   */
            {
                _tprintf(_T("Container TestRtContainer has been acquired successfully.\n"));
            }
            else
            {
                Error("Acquire of TestRtContainer failed.\n");
            }
        }
        else
        {
            Error("Creation of TestRtContainer failed.\n");
        }
    }

/*    hCryptProv,        */
/* TestRtContainer                                                     */

/*---------------------------------------------------------------------*/
/*  2 :  RSA-  Rutoken   TestRtContainer. */ 
/*---------------------------------------------------------------------*/

/*        (KEYEXCHANGE   ),*/
/*                           */

    if( CryptGenKey(    hCryptProv,  /*   TestRtContainer   */
                        AT_KEYEXCHANGE,   
                        0,
                        &hRSAKey) )
    {
        _tprintf(_T("RSA pair has been generated successfully.\n"));
    }
    else
    {
        Error("RSA pair generation failed.\n");
    }

/*---------------------------------------------------------------------*/
/*  3 :      .             */
/*---------------------------------------------------------------------*/

/*    :                                         */
    if( CryptExportKey( hRSAKey,
                        0,
                        PUBLICKEYBLOB, //    
                        0, 
                        NULL,
                        &dwPubKeyBlobLen) )
    {
        _tprintf(_T("Length of public key BLOB: %d bit.\n"), dwPubKeyBlobLen);
    }
    else
    {
        Error("Cannot obtain length of public key BLOB: .\n");
    }

/*                                              */
    pbPubKeyBlob = (BYTE*)malloc(dwPubKeyBlobLen);

/*                                      */
    if( CryptExportKey( hRSAKey,
                        0,
                        PUBLICKEYBLOB, //    
                        0, 
                        pbPubKeyBlob,
                        &dwPubKeyBlobLen) )
    {
        _tprintf(_T("Public key has been exported successfully.\n"));
    }
    else
    {
        Error("Export of public key failed.\n");
    }

/*  ,  -        */
/* , ..   pbPubKeyBlob    */
/*     B.   ,  */
/*     B:                                    */

/*---------------------------------------------------------------------*/
/*  4 :    RSA  CSP.                      */
/*---------------------------------------------------------------------*/
    
/* (        )      */

    if( CryptImportKey( hCryptProv,
                        pbPubKeyBlob,
                        dwPubKeyBlobLen,
                        0,
                        0,
                        &hPubKeyOnBComp) )
    {
        _tprintf(_T("Public key has been imported successfully.\n"));
    }
    else
    {
        Error("Import of public key failed.\n");
    }

/*---------------------------------------------------------------------*/
/*  5 :     RC2.                 */
/*---------------------------------------------------------------------*/
    
    if( CryptGenKey(    hCryptProv,
                        CALG_RC2,
                        CRYPT_EXPORTABLE, /*     CSP */
                        &hSymKey) )
    {
        _tprintf(_T("RC2 key has been generated successfully.\n"));
    }
    else
    {
        Error("RC2 key generation failed.\n");
    }


/*---------------------------------------------------------------------*/
/*  6 :     RC2,          */
/*          RSA-.                                         */
/*---------------------------------------------------------------------*/ 
     
    if( CryptExportKey( hSymKey,
                        hPubKeyOnBComp,
                        SIMPLEBLOB, /*           */
                        0, 
                        NULL,
                        &dwSymKeyBlobLen) )
    {
        _tprintf(_T("Length of RC2 key BLOB has been obtained successfully.\n"));
    }
    else
    {
        Error("Cannot obtain length of session key BLOB: .\n");
    }

/*         RC2               */
    pbSymKeyBlob = (BYTE*)malloc(dwSymKeyBlobLen);
    if(!pbSymKeyBlob)
    {
        Error("Out of memory.\n");
    }

/*---------------------------------------------------------------------*/
/*  7 :   CryptExportKey            */ 
/*          ,  hSymKey,       */
/*            .                             */
/*---------------------------------------------------------------------*/

    if( CryptExportKey( hSymKey,
                        hPubKeyOnBComp,
                        SIMPLEBLOB, 
                        0, 
                        pbSymKeyBlob,
                        &dwSymKeyBlobLen) )
    {
        _tprintf(_T("RC2 key BLOB has been obtained successfully.\n"));
    }
    else
    {
        Error("Export of RC2 key BLOB failed: .\n");
    }

/*  ,   B              */
/*   ,        .*/
/*     ,                     */
/*    .   B           */
/*        A           */
/*     +        */
/*  .  
/*                        */
/* .                                                    */

/* ,        .   */
/*      pbSymKeyBlob.                      */

/*---------------------------------------------------------------------*/
/*  8 :  RC2    .              */
/*---------------------------------------------------------------------*/

/*        ,    -          */
/*    .                                     */

//   RC2-,    
    if(CryptImportKey(  hCryptProv,
                        pbSymKeyBlob,
                        dwSymKeyBlobLen,
                        hRSAKey,//    RC2-
                        0,
                        &hSymKeyOnAComp) )
    {
        _tprintf(_T("RC2 key BLOB has been imported successfully.\n"));
    }
    else
    {
        Error("Import of RC2 key BLOB failed: .\n");
    }

//-        
//-  B                             

    free(pbSymKeyBlob);
    free(pbPubKeyBlob);

    CryptDestroyKey(hSymKey);
    CryptDestroyKey(hRSAKey);

//-  
    if(!CryptReleaseContext(    hCryptProv,                      
                                0) )
    {
        Error("Cannot release context!\n");
    }
    
    _tprintf(_T("Context has been released successfully.\n"));

//-   TestRtContainer

    if( !CryptAcquireContext(   &hCryptProv,
                                pszContainerName,
                                MYPROV,
                                PROV_RSA_FULL,
                                CRYPT_DELETEKEYSET) )
    {
        Error("Cannot delete container TestRtContainer!\n");
    }

    _tprintf(_T("Container has been deleted successfully.\n"));

    _tprintf(_T("Press Enter to exit.\n"));

    getchar();
}
