/************************************************************************
* Rutoken                                                               *
* Copyright (C) Aktiv Co. 2003 - 2014                                   *
*  :  http://www.rutoken.ru                          *
*  :    http://www.rutoken.ru/hotline/download/drivers/*
*  : http://www.rutoken.ru/hotline/                 *
*-----------------------------------------------------------------------*
*    Rutoken   Rutoken Cryptographic Service      *
* Provider  C                                                         *
*-----------------------------------------------------------------------*
*      RC2                       *
*-----------------------------------------------------------------------*
* -                                   *
* -     RC2                         *
* -                                        *
* -                                                  *
************************************************************************/

//      CAPI, :  
// #define _WIN32_WINNT 0x0400 

//  ,   Rutoken CSP
#include "rtCSP_Err.h"

#include <stdio.h>
#include <tchar.h>
#include <windows.h>
#include <wincrypt.h>


/*    */
#define MYPROV TEXT("Aktiv Rutoken CSP v1.0")   

/*   RC2 */
#define ALGID CALG_RC2 //        
/*   */
#define BUF_LEN 100 

/*   */
TCHAR szStr2Encr[BUF_LEN] = TEXT("String to be encrypted and decrypted");

/*  CSP */
HCRYPTPROV hCryptProv;
/*     */
HCRYPTKEY  hSymKey;
/*  */
DWORD dwStringLen;
/*   */
DWORD dwNumberOfEncipheredBytes;
/*   */
DWORD dwBlockLen;
/*  */    
DWORD dwDataLen = 4;
/*  */
DWORD dwKeyLen;

/************************************************************************
*                            *
************************************************************************/
void Error( IN char *s //    
            )
{
    _tprintf(_T("Error happened: %s\n"),s);
    _tprintf(_T("Error number: 0x%x\n."), GetLastError());
    _tprintf(_T("Exit program.\n"));
    getchar();
    exit(1);
}

/************************************************************************
* Main()                                                                *
************************************************************************/

void main(void) 
{
/*---------------------------------------------------------------------*/
/*  1 :    Aktiv Rutoken CSP v1.0.   */
/*---------------------------------------------------------------------*/
    if(CryptAcquireContext( &hCryptProv, 
                            NULL,          
                            MYPROV, 
                            PROV_RSA_FULL, 
                            CRYPT_VERIFYCONTEXT ))
    {
        _tprintf(_T("CryptAcquireContext has been completed successfully.\n"));
    }
    else
    {
        Error("CryptAcquireContext failed.\n");
    }

/*---------------------------------------------------------------------*/
/*  2 :    RC2.                              */
/*---------------------------------------------------------------------*/

    if(CryptGenKey( hCryptProv,
                    ALGID,
                    0,  
                    &hSymKey))
    {
        _tprintf(_T("RC2 key has been generated successfully.\n"));
    }
    else
    {
        Error("RC2 key generation failed.\n");
    }

/*---------------------------------------------------------------------*/
/*  3 :   ( RC2  ).                  */
/*---------------------------------------------------------------------*/

//    
//  ALGID -   ,   
// ( CALG_RC4),   dwBlockLen == 0
    if(CryptGetKeyParam(    hSymKey,
                            KP_BLOCKLEN,
                            (BYTE*)&dwBlockLen,
                            &dwDataLen,
                            0) )
    {
        _tprintf(_T("Block length obtained: %d bits.\n"), dwBlockLen);
    }
    else
    {
        Error("Cannot obtain block length.\n");
    }
    
//     0  :
    dwStringLen = (DWORD)((_tcslen(szStr2Encr) + 1)*sizeof(TCHAR)); 

//   - ,       
//   . ,   dwStringLen ( 
//   )   dwBlockLen,   
//     (,  ,    - 
//    CryptEncrypt)  . 
//      .
        
    dwNumberOfEncipheredBytes = dwStringLen;

    _tprintf(_T("Encrypt string: %s \n"), szStr2Encr);

/*---------------------------------------------------------------------*/
/*  4 : .                                               */
/*---------------------------------------------------------------------*/

    if(CryptEncrypt(    hSymKey,
                        0,
                        TRUE, //   
                        0,
                        (BYTE*)szStr2Encr,
                        &dwNumberOfEncipheredBytes, 
                        BUF_LEN) )
    {
        _tprintf(_T("%d bytes has been encrypted successfully.\n"), dwStringLen);
    }
    else
    {
        Error("Cannot encrypt block.\n");
    }

/*---------------------------------------------------------------------*/
/*  5 : .                                              */
/*---------------------------------------------------------------------*/

    if(CryptDecrypt(    hSymKey,
                        0,
                        TRUE, //   
                        0,
                        (BYTE*)szStr2Encr,
                        &dwNumberOfEncipheredBytes) )
    {
        _tprintf(_T("%d bytes has been decrypted successfully.\n"), dwNumberOfEncipheredBytes);
    }
    else
    {
        Error("Cannot decrypt block.\n");
    }

    _tprintf(_T("Decrypted string: %s \n"), szStr2Encr);

/*---------------------------------------------------------------------*/
/*  6 :   .                       */
/*---------------------------------------------------------------------*/
    if(!CryptReleaseContext(    hCryptProv,
                                0) )
    {
        Error("Cannot release context!\n");
    }
    _tprintf(_T("Context has been released successfully.\n"));

    _tprintf(_T("Press Enter to exit.\n"));

    getchar();
}
